# Sciencéthic

# Programme de mesures pour loi de Mariotte.
# Lecture d'un capteur de pression analogique sur le port A1.

# Le capteur de pression utilisé  Réf. 651 055: -1000/+2000 hPa (Sciencéthic)
# Le témoin LED de la carte Plug'Uno est utilisé (connecté a D13)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
#
brocheCapteurPression = plugUno.get_pin('a:1:i')
# -> a  : signifie mode analogique
# -> 1  : numéro de la broche
# -> i  : mode entrée
#
brocheLED = plugUno.get_pin('d:13:o')
# -> d  : signifie mode numerique/digital
# -> 13  : numéro de la broche
# -> o  : mode sortie/output

# Active le mécanisme de rapport d'état des E/S
plugUno.samplingOn()


################################
# Section mesures
################################
# Allume la LED pour indiquer que le programme est prêt...
# pour effectuer les mesures de préssion.
brocheLED.write(1)

# liste des mesures ADC et volumes saisit associé 
mesure=[]
volume=[] 

poursuite=True
while poursuite:
    
    volume.append( float(input("volume en mL :")) )
    
    input("Taper ENTER pour effectuer la mesure...")
    
    mesure.append( brocheCapteurPression.read() )
    print(volume[-1],'mL -> mesure : ' , mesure[-1])
    
    if input('nouvelle mesure (oui/non) ? ') == "non": poursuite=False
    
# Éteint la LED pour indiquer la fin des mesures.
brocheLED.write(0)
# fermeture de la communication sur le port
plugUno.exit()

# Affichage des résultats obtenu
print(
    "\n"
    "Volumes : ",volume,
    "\n"
    "Mesures : ",mesure,
)


################################
# Section tracés (facultatif)
# matplotlib doit être installé
# numpy doit être installé
################################
print('----------------------------------')

if input('Voulez-vous effectuer un tracé de ces mesures (oui/non) ? ') != 'non' :
    
    # importation de la bibliothèque pour le calcul de régression linéaire
    import numpy as np
    # bibliothèque de tracés
    import matplotlib.pyplot as plt
    
    inv_v=[]
    pression=[]

    # calcul des volumes en fonction du modèle du capteur
    for i in range(len(mesure)):
        inv_v.append(1/(volume[i]+3.1))
        pression.append(mesure[i]*3010)

    # régression linéaire
    regression = np.polyfit(inv_v, pression, 1)

    # initialisation de la fonction modèle linéaire
    f_reg=np.poly1d(regression)

    # tracé des valeurs expérimentales
    plt.plot(inv_v,pression,'+',label='mesures')

    # création des abcisses pour le tracé du modèle
    x=np.linspace(0,1.2*max(inv_v),50)

    # tracé du modèle
    plt.plot(x,f_reg(x),'-',color='r',label='régression linéaire')

    # titre de la figure
    plt.title('P=f(1/V)')    

    # paramétrage axe des abscisses entre 0 et 1,2*profondeur max
    plt.xlim(0, 1.2*max(inv_v))

    # paramétrage axe des ordonnées entre 0 et 1,2*pression max
    plt.ylim(0, 1.2*max(pression))

    # légendes des axes
    plt.xlabel('1/V (cm-3)')
    plt.ylabel('pression(hPa)')

    # paramétrages de la légende
    plt.legend(loc='lower right',fontsize=12)

    # tracé de la figure
    plt.show()
